//
//  GHUserGoal.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 8/8/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

/**
 *  Type of goal
 */
typedef NS_ENUM(NSInteger, GHGoalType){
    /**
     *  Number of steps taken per day
     */
    GHStepsTakenGoal = 4,
    /**
     *  Number of floors to climb per day
     */
    GHFloorsClimbedGoal = 5,
    /**
     *  Intensity minutes per week.
     */
    GHIntensityMinutesGoal = 6,
};


/**
 *  How the goal is determined
 */
typedef NS_ENUM(uint8_t, GHGoalSource){
    /**
     *  System will define the step goal
     */
    GHAutomaticGoal = 0,
    /**
     *  User will define the goal
     */
    GHUserDefinedGoal = 2,
};


/**
 *  The GHUserGoal class provides information about goals.
 */
#pragma mark -
@interface GHUserGoal : NSObject<NSCoding, NSCopying>
    
/** 
 *  The source of the goal. Refer to GHGoalSource for additional information. 
 */
@property (nonatomic) GHGoalSource source;

/** 
 *  The type of the goal. Refer to GHGoalType for additional information. 
 */
@property (nonatomic) GHGoalType type;

/** 
 *  The value of the goal. 
 *  @note Step goals have a minimum value of 0 and a maximum value of 99999.
 *  Floors climbed goals have a minimum value of 0 and a maximum value of 999.
 *  Intensity minute goals have a minimum value of 150 and a maximum value of 99999.
 */
@property (nonatomic) int value;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;

/**
 *  Prefered initialization method.
 *  @param goal  User goal to use.
*/
- (instancetype)initWithUserGoal:(GHUserGoal *)goal;


@end
